module printExample1

//********************************************************************************
//  Clean 0.8 I/O library example program.
//
//  This program demonstrates the use of the "print" function.
//  It prints two pages, one with the text "Hello Printer", and one, that informs
//  about the printer's resolution.
//********************************************************************************

import StdEnv, deltaPrint, deltaPicture

Start world
    # (defaultPS, world) = defaultPrintSetup world
    = snd (accFiles (print True False pages defaultPS) world)
  where
    pages :: PrintInfo *Picture -> ([*Picture->*Picture],*Picture)
    pages { printSetup, jobInfo={ range=(first,last), copies } } picture
      # {resolution=(xRes,_)} = getPageDimensions printSetup False
        bothPages
            = [ seq [MovePenTo (100, 100), DrawString  "Hello Printer"],
				seq [MovePenTo (100, 100),
				     DrawString ("horizontal Resolution: "+++toString xRes
                                                          +++" dpi.") ]]
        oneCopy = bothPages % (first-1,last-1)
      = ( flatten (repeatn copies oneCopy), picture)

